<?php

if ( ! function_exists( 'rishi__cb_customizer_social_icons' ) ) {
	function rishi__cb_customizer_social_icons( $socials_descriptor = null, $args = array() ) {
		$args = wp_parse_args(
			$args,
			array(
				'icons-color' => 'custom',
				'type'        => 'simple',
				'size'        => 'custom',
				'fill'        => false,
				'hide_labels' => true,
			)
		);

		$attr = array(
			'data-icon-size' => $args['size'],
			'data-color'     => $args['icons-color'],
		);

		// if ($args['type'] !== 'simple') {
		$attr['data-icons-type'] = $args['type'];
		// }

		if ( $args['fill'] ) {
			if ( $args['type'] !== 'simple' ) {
				$attr['data-icons-type'] .= ':' . $args['fill'];
			}
		}

		return rishi__cb_customizer_get_social_box(
			array(
				'attr'        => $attr,
				'socials'     => $socials_descriptor,
				'hide_labels' => $args['hide_labels'],
			)
		);
	}
}

/**
 * Get social share box.
 */
if ( ! function_exists( 'rishi__cb_customizer_get_social_share_box' ) ) {
	function rishi__cb_customizer_get_social_share_box( $args = array() ) {
		$args = wp_parse_args(
			$args,
			array(
				'html_atts'          => array(),
				'links_wrapper_attr' => array(),
				'type'               => 'type-1',
				'custom_share_url'   => '',
			)
		);

		$prefix = rishi__cb_customizer_manager()->screen->get_prefix();

		if (!isset($args['html_atts']['data-type'])) {
			$args['html_atts']['data-type'] = $args['type'];
		}
		$brand_color = get_theme_mod( 'social_share_color_option','brand' );
		if (!isset($args['html_atts']['data-color']) && $brand_color ) {
			$args['html_atts']['data-color'] = $brand_color;
		}

		if ( !isset($args['html_atts']['data-float']) ) {
			$args['html_atts']['data-float'] = get_theme_mod( 'single_blog_post_box_float','left');
		}

		if ( !isset($args['html_atts']['data-shape']) ) {
			$args['html_atts']['data-shape'] = get_theme_mod( 'single_blog_post_box_shape','square');
		}

		if ( !isset($args['html_atts']['data-sticky']) ) {
			$args['html_atts']['data-sticky'] = get_theme_mod( 'single_blog_post_box_sticky','no');
		}

		if ( !isset($args['html_atts']['data-alignment']) ) {
			$args['html_atts']['data-alignment'] = get_theme_mod( 'single_blog_post_share_alignment','left');
		}

		$before_content = '';
		$after_content = '';

		if (
			get_theme_mod($prefix . '_has_share_box_title', 'no') === 'yes'
		) {
			$before_content = '<div>';
			$after_content = '</div>';
			$before_content .= rishi__cb_customizer_html_tag(
				'span',
				[
					'class' => 'rt-module-title'
				],
				get_theme_mod(
					$prefix . '_share_box_title',
					__('SHARE THIS POST', 'rishi')
				)
			);
		}

		return rishi__cb_customizer_get_social_box([
			'type' => 'share',
			'root_class' => 'cb__share-box',
			'class' => rishi__cb_customizer_visibility_classes(
				get_theme_mod($prefix . '_visibility', [
					'desktop' => true,
					'tablet' => true,
					'mobile' => false,
				])
			),
			'attr' => $args['html_atts'],
			'links_wrapper' => 'div',
			'links_wrapper_attr' => $args['links_wrapper_attr'],
			'before_links_content' => $before_content,
			'after_links_content' => $after_content,
			'custom_share_url' => $args['custom_share_url'],
			'links_rel' => get_theme_mod(
				$prefix . '_share_links_nofollow',
				'yes'
			) === 'yes' ? 'noopener noreferrer nofollow' : 'noopener'
		]);

	}
}

if ( ! function_exists( 'rishi__cb_customizer_get_dynamic_social_networks' ) ) {
	function rishi__cb_customizer_get_dynamic_social_networks() {
		$networks = apply_filters(
			'rishi:social-box:dynamic-social-networks',
			array()
		);

		foreach ( $networks as $network ) {
		 rishi__cb_customizer_assert_args( $network, array( 'id', 'name', 'icon' ) );
		}

		return $networks;
	}
}

if ( ! function_exists( 'rishi__cb_customizer_get_social_metadata' ) ) {
	function rishi__cb_customizer_get_social_metadata( $args = array() ) {
		$args = wp_parse_args(
			$args,
			array(
				// url | share
				'type'       => 'url',
				'custom_url' => '',
				'social'     => null,
			)
		);

		$metadata = [
			'facebook' => [
				'name' => __('Facebook', 'rishi'),
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 24 24">
					<path d="m15.997 3.985h2.191v-3.816c-.378-.052-1.678-.169-3.192-.169-3.159 0-5.323 1.987-5.323 5.639v3.361h-3.486v4.266h3.486v10.734h4.274v-10.733h3.345l.531-4.266h-3.877v-2.939c.001-1.233.333-2.077 2.051-2.077z"/>
				</svg>
			',
			],

			'twitter' => [
				'name' => __('Twitter', 'rishi'),
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M20,3.8c-0.7,0.3-1.5,0.5-2.4,0.6c0.8-0.5,1.5-1.3,1.8-2.3c-0.8,0.5-1.7,0.8-2.6,1c-0.7-0.8-1.8-1.3-3-1.3c-2.3,0-4.1,1.8-4.1,4.1c0,0.3,0,0.6,0.1,0.9C6.4,6.7,3.4,5.1,1.4,2.6C1,3.2,0.8,3.9,0.8,4.7c0,1.4,0.7,2.7,1.8,3.4C2,8.1,1.4,7.9,0.8,7.6c0,0,0,0,0,0.1c0,2,1.4,3.6,3.3,4c-0.3,0.1-0.7,0.1-1.1,0.1c-0.3,0-0.5,0-0.8-0.1c0.5,1.6,2,2.8,3.8,2.8c-1.4,1.1-3.2,1.8-5.1,1.8c-0.3,0-0.7,0-1-0.1c1.8,1.2,4,1.8,6.3,1.8c7.5,0,11.7-6.3,11.7-11.7c0-0.2,0-0.4,0-0.5C18.8,5.3,19.4,4.6,20,3.8z"/>
				</svg>
			',
			],

			'instagram' => [
				'name' => 'Instagram',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 511 511.9">
					<path d="m510.949219 150.5c-1.199219-27.199219-5.597657-45.898438-11.898438-62.101562-6.5-17.199219-16.5-32.597657-29.601562-45.398438-12.800781-13-28.300781-23.101562-45.300781-29.5-16.296876-6.300781-34.898438-10.699219-62.097657-11.898438-27.402343-1.300781-36.101562-1.601562-105.601562-1.601562s-78.199219.300781-105.5 1.5c-27.199219 1.199219-45.898438 5.601562-62.097657 11.898438-17.203124 6.5-32.601562 16.5-45.402343 29.601562-13 12.800781-23.097657 28.300781-29.5 45.300781-6.300781 16.300781-10.699219 34.898438-11.898438 62.097657-1.300781 27.402343-1.601562 36.101562-1.601562 105.601562s.300781 78.199219 1.5 105.5c1.199219 27.199219 5.601562 45.898438 11.902343 62.101562 6.5 17.199219 16.597657 32.597657 29.597657 45.398438 12.800781 13 28.300781 23.101562 45.300781 29.5 16.300781 6.300781 34.898438 10.699219 62.101562 11.898438 27.296876 1.203124 36 1.5 105.5 1.5s78.199219-.296876 105.5-1.5c27.199219-1.199219 45.898438-5.597657 62.097657-11.898438 34.402343-13.300781 61.601562-40.5 74.902343-74.898438 6.296876-16.300781 10.699219-34.902343 11.898438-62.101562 1.199219-27.300781 1.5-36 1.5-105.5s-.101562-78.199219-1.300781-105.5zm-46.097657 209c-1.101562 25-5.300781 38.5-8.800781 47.5-8.601562 22.300781-26.300781 40-48.601562 48.601562-9 3.5-22.597657 7.699219-47.5 8.796876-27 1.203124-35.097657 1.5-103.398438 1.5s-76.5-.296876-103.402343-1.5c-25-1.097657-38.5-5.296876-47.5-8.796876-11.097657-4.101562-21.199219-10.601562-29.398438-19.101562-8.5-8.300781-15-18.300781-19.101562-29.398438-3.5-9-7.699219-22.601562-8.796876-47.5-1.203124-27-1.5-35.101562-1.5-103.402343s.296876-76.5 1.5-103.398438c1.097657-25 5.296876-38.5 8.796876-47.5 4.101562-11.101562 10.601562-21.199219 19.203124-29.402343 8.296876-8.5 18.296876-15 29.398438-19.097657 9-3.5 22.601562-7.699219 47.5-8.800781 27-1.199219 35.101562-1.5 103.398438-1.5 68.402343 0 76.5.300781 103.402343 1.5 25 1.101562 38.5 5.300781 47.5 8.800781 11.097657 4.097657 21.199219 10.597657 29.398438 19.097657 8.5 8.300781 15 18.300781 19.101562 29.402343 3.5 9 7.699219 22.597657 8.800781 47.5 1.199219 27 1.5 35.097657 1.5 103.398438s-.300781 76.300781-1.5 103.300781zm0 0"/><path d="m256.449219 124.5c-72.597657 0-131.5 58.898438-131.5 131.5s58.902343 131.5 131.5 131.5c72.601562 0 131.5-58.898438 131.5-131.5s-58.898438-131.5-131.5-131.5zm0 216.800781c-47.097657 0-85.300781-38.199219-85.300781-85.300781s38.203124-85.300781 85.300781-85.300781c47.101562 0 85.300781 38.199219 85.300781 85.300781s-38.199219 85.300781-85.300781 85.300781zm0 0"/><path d="m423.851562 119.300781c0 16.953125-13.746093 30.699219-30.703124 30.699219-16.953126 0-30.699219-13.746094-30.699219-30.699219 0-16.957031 13.746093-30.699219 30.699219-30.699219 16.957031 0 30.703124 13.742188 30.703124 30.699219zm0 0"/>
				</svg>
			'
			],

			'pinterest' => [
				'name' => __('Pinterest', 'rishi'),
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M10,0C4.5,0,0,4.5,0,10c0,4.1,2.5,7.6,6,9.2c0-0.7,0-1.5,0.2-2.3c0.2-0.8,1.3-5.4,1.3-5.4s-0.3-0.6-0.3-1.6c0-1.5,0.9-2.6,1.9-2.6c0.9,0,1.3,0.7,1.3,1.5c0,0.9-0.6,2.3-0.9,3.5c-0.3,1.1,0.5,1.9,1.6,1.9c1.9,0,3.2-2.4,3.2-5.3c0-2.2-1.5-3.8-4.2-3.8c-3,0-4.9,2.3-4.9,4.8c0,0.9,0.3,1.5,0.7,2C6,12,6.1,12.1,6,12.4c0,0.2-0.2,0.6-0.2,0.8c-0.1,0.3-0.3,0.3-0.5,0.3c-1.4-0.6-2-2.1-2-3.8c0-2.8,2.4-6.2,7.1-6.2c3.8,0,6.3,2.8,6.3,5.7c0,3.9-2.2,6.9-5.4,6.9c-1.1,0-2.1-0.6-2.4-1.2c0,0-0.6,2.3-0.7,2.7c-0.2,0.8-0.6,1.5-1,2.1C8.1,19.9,9,20,10,20c5.5,0,10-4.5,10-10C20,4.5,15.5,0,10,0z"/>
				</svg>
			',
			],

			'dribbble' => [
				'name' => 'Dribbble',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M10,0C4.5,0,0,4.5,0,10c0,5.5,4.5,10,10,10c5.5,0,10-4.5,10-10C20,4.5,15.5,0,10,0 M16.1,5.2c1,1.2,1.6,2.8,1.7,4.4c-1.1-0.2-2.2-0.4-3.2-0.4v0h0c-0.8,0-1.6,0.1-2.3,0.2c-0.2-0.4-0.3-0.8-0.5-1.2C13.4,7.6,14.9,6.6,16.1,5.2 M10,2.2c1.8,0,3.5,0.6,4.9,1.7c-1,1.2-2.4,2.1-3.8,2.7c-1-2-2-3.4-2.7-4.3C8.9,2.3,9.4,2.2,10,2.2 M6.6,3c0.5,0.6,1.6,2,2.8,4.2C7,8,4.6,8.1,3.2,8.1c0,0-0.1,0-0.1,0h0c-0.2,0-0.4,0-0.6,0C3,5.9,4.5,4,6.6,3 M2.2,10c0,0,0-0.1,0-0.1c0.2,0,0.5,0,0.9,0h0c1.6,0,4.3-0.1,7.1-1c0.2,0.3,0.3,0.7,0.4,1c-1.9,0.6-3.3,1.6-4.4,2.6c-1,0.9-1.7,1.9-2.2,2.5C2.9,13.7,2.2,11.9,2.2,10 M10,17.8c-1.7,0-3.3-0.6-4.6-1.5c0.3-0.5,0.9-1.3,1.8-2.2c1-0.9,2.3-1.9,4.1-2.5c0.6,1.7,1.1,3.6,1.5,5.7C11.9,17.6,11,17.8,10,17.8M14.4,16.4c-0.4-1.9-0.9-3.7-1.4-5.2c0.5-0.1,1-0.1,1.6-0.1h0h0h0c0.9,0,2,0.1,3.1,0.4C17.3,13.5,16.1,15.3,14.4,16.4"/>
				</svg>
			'
			],

			'behance' => [
				'name' => 'Behance',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 511.958 511.958">
					<path d="M210.624,240.619c10.624-5.344,18.656-11.296,24.16-17.728c9.792-11.584,14.624-26.944,14.624-45.984
					c0-18.528-4.832-34.368-14.496-47.648c-16.128-21.632-43.424-32.704-82.016-33.28H0v312.096h142.56
					c16.064,0,30.944-1.376,44.704-4.192c13.76-2.848,25.664-8.064,35.744-15.68c8.96-6.624,16.448-14.848,22.4-24.544
					c9.408-14.656,14.112-31.264,14.112-49.76c0-17.92-4.128-33.184-12.32-45.728C238.912,255.627,226.752,246.443,210.624,240.619z
					M63.072,150.187h68.864c15.136,0,27.616,1.632,37.408,4.864c11.328,4.704,16.992,14.272,16.992,28.864
					c0,13.088-4.32,22.24-12.864,27.392c-8.608,5.152-19.776,7.744-33.472,7.744H63.072V150.187z M171.968,348.427
					c-7.616,3.68-18.336,5.504-32.064,5.504H63.072v-83.232h77.888c13.568,0.096,24.128,1.888,31.68,5.248
					c13.44,6.08,20.128,17.216,20.128,33.504C192.768,328.651,185.856,341.579,171.968,348.427z"/>
					<rect x="327.168" y="110.539" width="135.584" height="38.848"/>
					<path d="M509.856,263.851c-2.816-18.08-9.024-33.984-18.688-47.712c-10.592-15.552-24.032-26.944-40.384-34.144
					c-16.288-7.232-34.624-10.848-55.04-10.816c-34.272,0-62.112,10.72-83.648,32c-21.472,21.344-32.224,52.032-32.224,92.032
					c0,42.656,11.872,73.472,35.744,92.384c23.776,18.944,51.232,28.384,82.4,28.384c37.728,0,67.072-11.232,88.032-33.632
					c13.408-14.144,20.992-28.064,22.656-41.728H446.24c-3.616,6.752-7.808,12.032-12.608,15.872
					c-8.704,7.04-20.032,10.56-33.92,10.56c-13.216,0-24.416-2.912-33.76-8.704c-15.424-9.28-23.488-25.536-24.512-48.672h170.464
					C512.16,289.739,511.52,274.411,509.856,263.851z M342.976,269.835c2.24-15.008,7.68-26.912,16.32-35.712
					c8.64-8.768,20.864-13.184,36.512-13.216c14.432,0,26.496,4.128,36.32,12.416c9.696,8.352,15.168,20.48,16.288,36.512H342.976z"/>
				</svg>
			'
			],

			'unsplash' => [
				'name' => 'Unsplash',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M6.2 5.6V0h7.5v5.6H6.2zm7.6 3.2H20V20H0V8.8h6.2v5.6h7.5V8.8z"/>
				</svg>
			'
			],

			'five-hundred-px' => [
				'name' => '500px',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M17.7 17.3c-.9.9-1.9 1.6-3 2-1.1.5-2.3.7-3.5.7-1.2 0-2.4-.2-3.5-.7-1.1-.5-2.1-1.1-2.9-2-.8-.8-1.5-1.8-2-2.9-.3-.8-.5-1.5-.6-2.1 0-.2.1-.3.5-.4.4-.1.6 0 .6.2.1.7.3 1.3.5 1.8.4.9.9 1.8 1.7 2.5.7.7 1.6 1.3 2.5 1.7 1 .4 2 .6 3.1.6s2.1-.2 3.1-.6c1-.4 1.8-1 2.5-1.7l.1-.1c.1-.1.2-.1.3-.1.1 0 .2.1.4.2.3.5.3.7.2.9zm-5.3-6.9l-.7.7.7.7c.2.2.1.3-.1.5-.1.1-.2.2-.4.2-.1 0-.1 0-.2-.1l-.7-.7-.7.7s-.1.1-.2.1-.2-.1-.3-.2c-.1-.1-.2-.2-.2-.3 0-.1 0-.1.1-.2l.7-.7-.7-.7c-.1-.1-.1-.3.2-.5.1-.1.2-.2.3-.2 0 0 .1 0 .1.1l.7.7.7-.7c.1-.1.3-.1.5.1.3.2.4.4.2.5zm5.3.6c0 .9-.2 1.7-.5 2.5s-.8 1.5-1.4 2.1c-.6.6-1.3 1.1-2.1 1.4-.8.3-1.6.5-2.5.5-.9 0-1.7-.2-2.5-.5s-1.5-.8-2.1-1.4c-.6-.6-1.1-1.3-1.4-2.1l-.2-.4c-.1-.2.1-.4.5-.5.4-.1.6-.1.7.1.3.7.6 1.4 1.1 1.9v-3.8c0-1 .4-1.9 1.1-2.6.8-.8 1.7-1.1 2.8-1.1 1.1 0 2 .4 2.8 1.1.8.8 1.2 1.7 1.2 2.8 0 1.1-.4 2-1.2 2.8-.8.8-1.7 1.2-2.8 1.2-.4 0-.8-.1-1.2-.2-.2-.1-.3-.3-.1-.7.1-.4.3-.5.5-.5h.2c.1 0 .2 0 .4.1s.3 0 .3 0c.8 0 1.4-.3 2-.8.5-.5.8-1.2.8-1.9 0-.8-.3-1.4-.8-1.9s-1.2-.8-2-.8-1.5.3-2 .9c-.7.6-.9 1.2-.9 1.8v4.6c.8.5 1.7.7 2.7.7.7 0 1.4-.1 2.1-.4.7-.3 1.2-.7 1.7-1.2s.9-1.1 1.2-1.7c.3-.7.4-1.3.4-2 0-1.5-.5-2.7-1.6-3.8-1-1-2.3-1.6-3.8-1.6s-2.8.5-3.8 1.6c-.4.4-.7.8-.8 1l-.2.2s-.1.1-.2.1h-.4c-.2 0-.3-.1-.4-.2S5 8.1 5 8V.4c0-.1 0-.2.1-.3s.2-.1.4-.1h9.8c.2 0 .3.2.3.6s-.1.6-.3.6H6.2v5.4c.3-.3.7-.6 1.2-.9.4-.3.8-.6 1.2-.7.8-.3 1.7-.5 2.6-.5.9 0 1.7.2 2.5.5s1.5.8 2.1 1.4c.6.6 1.1 1.3 1.4 2.1.3.8.5 1.7.5 2.5zm-.4-6.4c.1.1.1.1.1.2s0 .1-.1.2l-.2.2c-.2.2-.3.3-.4.3-.1 0-.1 0-.2-.1-.8-.7-1.6-1.2-2.3-1.5-1-.4-2-.6-3.1-.6-1 0-2 .2-2.9.5-.1.1-.3 0-.4-.4-.1-.2-.1-.3-.1-.4 0-.1.1-.2.2-.2 1-.4 2.1-.6 3.3-.6 1.2 0 2.4.2 3.5.7 1 .4 1.9 1 2.6 1.7z"/>
				</svg>
			'
			],

			'linkedin' => [
				'name' => __('LinkedIn', 'rishi'),
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 24 24">
					<path d="m23.994 24v-.001h.006v-8.802c0-4.306-.927-7.623-5.961-7.623-2.42 0-4.044 1.328-4.707 2.587h-.07v-2.185h-4.773v16.023h4.97v-7.934c0-2.089.396-4.109 2.983-4.109 2.549 0 2.587 2.384 2.587 4.243v7.801z"/><path d="m.396 7.977h4.976v16.023h-4.976z"/><path d="m2.882 0c-1.591 0-2.882 1.291-2.882 2.882s1.291 2.909 2.882 2.909 2.882-1.318 2.882-2.909c-.001-1.591-1.292-2.882-2.882-2.882z"/>
				</svg>
			',
			],

			'wordpress' => [
				'name' => 'WordPress',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 96.682 96.682">
					<path d="M48.343,0C21.686,0,0.002,21.683,0.002,48.339c0,26.657,21.684,48.343,48.341,48.343c26.653,0,48.337-21.686,48.337-48.343
					C96.68,21.686,74.996,0,48.343,0z M5.55,48.339c0-6.203,1.332-12.094,3.706-17.413l20.412,55.925
					C15.394,79.916,5.55,65.279,5.55,48.339z M48.343,91.135c-4.201,0-8.255-0.62-12.09-1.744l12.838-37.307l13.157,36.033
					c0.084,0.211,0.189,0.406,0.304,0.59C58.105,90.273,53.324,91.135,48.343,91.135z M54.238,28.277
					c2.576-0.136,4.896-0.409,4.896-0.409c2.307-0.272,2.037-3.659-0.271-3.523c0,0-6.932,0.543-11.405,0.543
					c-4.203,0-11.272-0.543-11.272-0.543c-2.305-0.136-2.573,3.39-0.27,3.523c0,0,2.183,0.272,4.486,0.409l6.667,18.266L37.706,74.63
					L22.125,28.279c2.579-0.136,4.898-0.408,4.898-0.408c2.303-0.272,2.034-3.661-0.275-3.523c0,0-6.929,0.542-11.405,0.542
					c-0.806,0-1.749-0.021-2.753-0.052C20.238,13.219,33.392,5.549,48.343,5.549c11.142,0,21.283,4.26,28.896,11.232
					c-0.187-0.009-0.364-0.033-0.556-0.033c-4.202,0-7.187,3.661-7.187,7.595c0,3.525,2.031,6.51,4.203,10.034
					c1.629,2.853,3.527,6.514,3.527,11.803c0,3.663-1.406,7.914-3.256,13.833l-4.268,14.263L54.238,28.277z M69.854,85.326l13.07-37.79
					c2.445-6.104,3.254-10.986,3.254-15.328c0-1.573-0.104-3.038-0.288-4.4c3.345,6.095,5.245,13.091,5.243,20.532
					C91.133,64.126,82.574,77.908,69.854,85.326z"/>
				</svg>
			',
			],

			'parler' => [
				'name' => __('Parler', 'rishi'),
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M11.7,16.7h-5V15c0-0.9,0.7-1.6,1.6-1.6h3.4c2.8,0,5-2.2,5-5s-2.2-5-5-5h0l-1.1,0H0C0,1.5,1.5,0,3.3,0h7.3l1.1,0C16.3,0,20,3.8,20,8.4S16.3,16.7,11.7,16.7z M3.3,20C1.5,20,0,18.5,0,16.7V9.9c0-1.8,1.4-3.2,3.2-3.2h8.4c0.9,0,1.7,0.7,1.7,1.7c0,0.9-0.7,1.7-1.7,1.7H5c-0.9,0-1.6,0.7-1.6,1.6V20z"/>
				</svg>
			',
			],

			'medium' => [
				'name' => 'Medium',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M2.4,5.3c0-0.2-0.1-0.5-0.3-0.7L0.3,2.4V2.1H6l4.5,9.8l3.9-9.8H20v0.3l-1.6,1.5c-0.1,0.1-0.2,0.3-0.2,0.4v11.2c0,0.2,0,0.3,0.2,0.4l1.6,1.5v0.3h-7.8v-0.3l1.6-1.6c0.2-0.2,0.2-0.2,0.2-0.4V6.5L9.4,17.9H8.8L3.6,6.5v7.6c0,0.3,0.1,0.6,0.3,0.9L6,17.6v0.3H0v-0.3L2.1,15c0.2-0.2,0.3-0.6,0.3-0.9V5.3z"/>
				</svg>
			'
			],

			'slack' => [
				'name' => 'Slack',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M7.4,0C6.2,0,5.2,1,5.2,2.2s1,2.2,2.2,2.2h2.2V2.2C9.6,1,8.6,0,7.4,0zM12.6,0c-1.2,0-2.2,1-2.2,2.2v5.2c0,1.2,1,2.2,2.2,2.2s2.2-1,2.2-2.2V2.2C14.8,1,13.8,0,12.6,0z M2.2,5.2C1,5.2,0,6.2,0,7.4s1,2.2,2.2,2.2h5.2c1.2,0,2.2-1,2.2-2.2s-1-2.2-2.2-2.2H2.2zM17.8,5.2c-1.2,0-2.2,1-2.2,2.2v2.2h2.2c1.2,0,2.2-1,2.2-2.2S19,5.2,17.8,5.2z M2.2,10.4c-1.2,0-2.2,1-2.2,2.2s1,2.2,2.2,2.2s2.2-1,2.2-2.2v-2.2H2.2zM7.4,10.4c-1.2,0-2.2,1-2.2,2.2v5.2c0,1.2,1,2.2,2.2,2.2s2.2-1,2.2-2.2v-5.2C9.6,11.4,8.6,10.4,7.4,10.4z M12.6,10.4c-1.2,0-2.2,1-2.2,2.2s1,2.2,2.2,2.2h5.2c1.2,0,2.2-1,2.2-2.2s-1-2.2-2.2-2.2H12.6zM10.4,15.7v2.2c0,1.2,1,2.2,2.2,2.2s2.2-1,2.2-2.2c0-1.2-1-2.2-2.2-2.2H10.4z"/>
				</svg>
			'
			],

			'codepen' => [
				'name' => 'CodePen',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M10,0L0,6.4v7.3L10,20l10-6.4V6.4L10,0z M10,12l-2.8-2L10,8.1l2.8,1.9L10,12z M11,6.5V2.8l6.4,4.1l-2.9,2L11,6.5z M9,6.5L5.5,8.9l-2.9-2L9,2.8V6.5z M3.9,10l-1.9,1.3V8.7L3.9,10z M5.5,11.2L9,13.6v3.5l-6.4-4.1L5.5,11.2z M11,13.6l3.5-2.5l2.8,1.9L11,17.2V13.6z M16.1,10l1.9-1.4v2.7L16.1,10z"/>
				</svg>
			'
			],

			'reddit' => [
				'name' => 'Reddit',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M11.7,0.9c-0.9,0-2,0.7-2.1,3.9c0.1,0,0.3,0,0.4,0c0.2,0,0.3,0,0.5,0c0.1-1.9,0.6-3.1,1.3-3.1c0.3,0,0.5,0.2,0.8,0.5c0.4,0.4,0.9,0.9,1.8,1.1c0-0.1,0-0.2,0-0.4c0-0.2,0-0.4,0.1-0.5c-0.6-0.2-0.9-0.5-1.2-0.8C12.8,1.3,12.4,0.9,11.7,0.9z M16.9,1.3c-1,0-1.7,0.8-1.7,1.7s0.8,1.7,1.7,1.7s1.7-0.8,1.7-1.7S17.9,1.3,16.9,1.3z M10,5.7c-5.3,0-9.5,2.7-9.5,6.5s4.3,6.9,9.5,6.9s9.5-3.1,9.5-6.9S15.3,5.7,10,5.7z M2.4,6.1c-0.6,0-1.2,0.3-1.7,0.7C0,7.5-0.2,8.6,0.2,9.5C0.9,8.2,2,7.1,3.5,6.3C3.1,6.2,2.8,6.1,2.4,6.1z M17.6,6.1c-0.4,0-0.7,0.1-1.1,0.3c1.5,0.8,2.6,1.9,3.2,3.2c0.4-0.9,0.3-2-0.5-2.7C18.8,6.3,18.2,6.1,17.6,6.1z M6.5,9.6c0.7,0,1.3,0.6,1.3,1.3s-0.6,1.3-1.3,1.3s-1.3-0.6-1.3-1.3S5.8,9.6,6.5,9.6z M13.5,9.6c0.7,0,1.3,0.6,1.3,1.3s-0.6,1.3-1.3,1.3s-1.3-0.6-1.3-1.3S12.8,9.6,13.5,9.6z M6.1,14.3c0.1,0,0.2,0.1,0.3,0.2c0,0.1,1.1,1.4,3.6,1.4c2.6,0,3.6-1.4,3.6-1.4c0.1-0.2,0.4-0.2,0.6-0.1c0.2,0.1,0.2,0.4,0.1,0.6c-0.1,0.1-1.3,1.8-4.3,1.8c-3,0-4.2-1.7-4.3-1.8c-0.1-0.2-0.1-0.5,0.1-0.6C5.9,14.4,6,14.3,6.1,14.3z"/>
				</svg>
			',
			],

			'twitch' => [
				'name' => 'Twitch',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20px"
				viewBox="0 0 20 20">
					<path d="M1.5,0L0,4.1v12.8h4.6V20h2.1l3.8-3.1h4.1l5.4-5.8V0H1.5zM3.1,1.5h15.4v8.8l-3.3,3.5H9.5l-3.4,2.9v-2.9H3.1V1.5z M7.7,4.6v6.2h1.5V4.6H7.7z M12.3,4.6v6.2h1.5V4.6H12.3z"/>
				</svg>
			',
			],

			'tiktok' => [
				'name' => 'TikTok',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M18.2 4.5c-2.3-.2-4.1-1.9-4.4-4.2V0h-3.4v13.8c0 1.4-1.2 2.6-2.8 2.6-1.4 0-2.6-1.1-2.6-2.6s1.1-2.6 2.6-2.6h.2l.5.1V7.5h-.7c-3.4 0-6.2 2.8-6.2 6.2S4.2 20 7.7 20s6.2-2.8 6.2-6.2v-7c1.1 1.1 2.4 1.6 3.9 1.6h.8V4.6l-.4-.1z"/>
				</svg>
			',
			],

			'snapchat' => [
				'name' => 'Snapchat',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M10,0.5c-6,0-6,6-6,6v1c0,0,0,0-0.1,0C3.6,7.5,2,7.6,2,8.9c0,1.5,1.7,1.6,2,1.6c0,0,0,0,0,0c0,1-1.7,2.2-2.7,2.4C0.3,13.3,0,14,0,14.5c0,0.3,0.1,0.5,0.1,0.6c0.4,0.9,1.5,1.3,2.6,1.3c0,1.4,1.1,2,1.8,2c0.8,0,1.6-0.4,1.6-0.4c0,0,1.3,1.4,3.9,1.4s3.9-1.4,3.9-1.4c0,0,0.8,0.4,1.6,0.4c0.7,0,1.7-0.6,1.8-2c1.1,0,2.2-0.5,2.6-1.3c0-0.1,0.1-0.3,0.1-0.6c0-0.5-0.3-1.2-1.3-1.6c-1.1-0.3-2.7-1.4-2.7-2.4c0,0,0,0,0,0c0.3,0,2-0.1,2-1.6c0-1.3-1.6-1.4-1.9-1.4c0,0-0.1,0-0.1,0v-1C16,6.5,16,0.5,10,0.5L10,0.5z"/>
				</svg>
			',
			],

			'spotify' => [
				'name' => 'Spotify',
				'icon' => '
				<svg
				class="rt-icon"
				width="20px"
				height="20"
				viewBox="0 0 20 20">
					<path d="M10,0C4.5,0,0,4.5,0,10s4.5,10,10,10s10-4.5,10-10S15.5,0,10,0z M14.2,14.5c-0.1,0.2-0.3,0.3-0.5,0.3c-0.1,0-0.2,0-0.4-0.1c-1.1-0.7-2.9-1.2-4.4-1.2c-1.6,0-2.8,0.4-2.8,0.4c-0.3,0.1-0.7-0.1-0.8-0.4c-0.1-0.3,0.1-0.7,0.4-0.8c0.1,0,1.4-0.5,3.2-0.5c1.5,0,3.6,0.4,5.1,1.4C14.4,13.8,14.4,14.2,14.2,14.5z M15.5,11.8c-0.1,0.2-0.4,0.4-0.6,0.4c-0.1,0-0.3,0-0.4-0.1c-1.9-1.2-4-1.5-5.7-1.5c-1.9,0-3.5,0.4-3.5,0.4c-0.4,0.1-0.8-0.1-0.9-0.5c-0.1-0.4,0.1-0.8,0.5-0.9c0.1,0,1.7-0.4,3.8-0.4c1.9,0,4.4,0.3,6.6,1.7C15.6,11,15.8,11.5,15.5,11.8z M16.8,8.7c-0.2,0.3-0.5,0.4-0.8,0.4c-0.1,0-0.3,0-0.4-0.1c-2.3-1.3-5-1.6-6.9-1.6c0,0,0,0,0,0c-2.3,0-4.1,0.4-4.1,0.4c-0.5,0.1-0.9-0.2-1-0.6c-0.1-0.5,0.2-0.9,0.6-1c0.1,0,2-0.5,4.5-0.5c0,0,0,0,0,0c2.1,0,5.2,0.3,7.8,1.9C16.9,7.8,17.1,8.3,16.8,8.7z"/>
				</svg>
			',
			],

			'soundcloud' => [
				'name' => 'SoundCloud',
				'icon' => '
				<svg
				class="rt-icon"
				width="20px"
				height="20"
				viewBox="0 0 20 20">
					<path d="M20 12.7c0 1.5-1.2 2.7-2.7 2.7h-6c-.4 0-.7-.3-.7-.7V5.3c0-.4.3-.7.7-.7h.7c3.3 0 6 2.7 4.7 5.3h.7c1.4.1 2.6 1.3 2.6 2.8zM.7 9.9c-.4 0-.7.3-.7.7v4.1c0 .4.3.7.7.7.4 0 .7-.3.7-.7v-4.1c-.1-.4-.4-.7-.7-.7zM6 5.3c-.4 0-.7.3-.7.7v8.7c0 .4.3.7.7.7s.7-.3.7-.7V6c0-.4-.3-.7-.7-.7zm2.7 2c-.4 0-.7.3-.7.7v6.7c0 .4.3.7.7.7.4 0 .7-.3.7-.7V8c-.1-.4-.4-.7-.7-.7zM3.3 8c-.3 0-.6.3-.6.7v6c0 .4.3.7.7.7.3-.1.6-.4.6-.7v-6c0-.4-.3-.7-.7-.7z"/>
				</svg>
			',
			],

			'apple_podcast' => [
				'name' => 'Apple Podcasts',
				'icon' => '
				<svg
				class="rt-icon"
				width="20px"
				height="20"
				viewBox="0 0 20 20">
					<path d="M10 0C5.1 0 1.1 4 1.1 8.9c0 2.9 1.4 5.5 3.6 7.1.3.2.5.4.8.5.3.2.8.1 1-.2.2-.3.1-.8-.2-1-.2-.1-.5-.3-.7-.5-1.8-1.4-3-3.6-3-6 0-4.2 3.4-7.5 7.5-7.5s7.5 3.4 7.5 7.5c0 2.5-1.2 4.7-3 6-.2.2-.5.3-.7.5-.3.2-.5.6-.3 1 .2.3.6.5 1 .3.3-.2.6-.4.8-.6 2.2-1.6 3.6-4.2 3.6-7.2C18.9 4 14.9 0 10 0zm0 2.8c-3.4 0-6.1 2.7-6.1 6.1 0 1.7.7 3.2 1.8 4.3.3.3.7.3 1 0s.3-.7 0-1c-.9-.9-1.4-2-1.4-3.3 0-2.6 2.1-4.7 4.7-4.7s4.7 2.1 4.7 4.7c0 1.3-.5 2.5-1.4 3.3-.3.3-.3.7 0 1 .3.3.7.3 1 0 1.1-1.1 1.8-2.6 1.8-4.3 0-3.3-2.7-6.1-6.1-6.1zm0 3.8C8.7 6.6 7.6 7.7 7.6 9s1.1 2.4 2.4 2.4 2.4-1.1 2.4-2.4-1.1-2.4-2.4-2.4zm0 5.6c-1.3 0-2.4 1.1-2.4 2.4v.5l.9 3.7c.2.7.8 1.2 1.5 1.2s1.3-.5 1.4-1.1l.9-3.7v-.1-.4c.1-1.4-1-2.5-2.3-2.5z"/>
				</svg>
			',
			],

			'patreon' => [
				'name' => 'Patreon',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M20,7.6c0,4-3.2,7.2-7.2,7.2c-4,0-7.2-3.2-7.2-7.2c0-4,3.2-7.2,7.2-7.2C16.8,0.4,20,3.6,20,7.6z M0,19.6h3.5V0.4H0V19.6z"/>
				</svg>
			'
			],

			'alignable' => [
				'name' => 'Alignable',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M19.5 6.7C18.1 2.8 14.3 0 9.9 0c-.7 0-1.4.1-2.1.3L6.6.6c.1.1.1.3.2.4.2.8.5 1.6.7 2.4.2.4.4.9.5 1.4.5 1.5 1.1 2.8 1.7 3.8.2.4.5.8.8 1.1.4.4.8.7 1.3.7.7 0 1.3-.6 1.9-1.4.5 1 1.1 2.3 1.5 3.5-.9.8-2 1.3-3.3 1.3-1 0-1.8-.3-2.6-.8-.3-.2-.7-.5-1-.8-1-.9-1.7-2.2-2.4-3.6-.3-.5-.5-1-.7-1.6C4.5 5.5 4 3.9 3.6 2.3c-.4.2-.7.6-1 .9C1 5 0 7.4 0 10c0 2.3.7 4.4 2 6.1.2.4.6.8.9 1.1.3-1.1.7-2.1 1-3.1.4-1.3.8-2.6 1.3-3.9.7 1.3 1.5 2.5 2.5 3.3-.2.6-.4 1.2-.6 1.7-.5 1.3-.9 2.7-1.4 4 .4.1.8.3 1.2.4 1 .3 2 .4 3 .4 2.7 0 5.2-1.1 7-2.8.4-.4.7-.7 1-1.1-.1-.3-.2-.7-.3-1-.3-.7-.5-1.5-.8-2.3-.2-.5-.3-.9-.5-1.4-.5-1.5-1.1-2.8-1.7-3.8-.2-.4-.5-.8-.8-1.1l-.3-.3c-.3-.3-.7-.4-1-.4-.7 0-1.3.6-1.9 1.4-.6-1-1.2-2.3-1.6-3.5.1-.1.2-.2.4-.3.9-.6 1.9-1 3-1 1 0 1.8.3 2.6.8.3.2.7.5 1 .8.9.9 1.7 2.2 2.3 3.5.3.5.5 1.1.7 1.6.3.7.6 1.4.8 2.1.2-.4.2-.8.2-1.2 0-1.1-.2-2.2-.5-3.3z"/>
				</svg>
			'
			],

			'skype' => [
				'name' => 'Skype',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M5.7 0C2.6 0 0 2.5 0 5.6c0 1 .2 1.9.7 2.7-.1.6-.2 1.2-.2 1.8 0 5.2 4.3 9.4 9.6 9.4.5 0 1.1 0 1.6-.1.8.4 1.7.6 2.6.6 3.1 0 5.7-2.5 5.7-5.6 0-.8-.2-1.6-.5-2.4.1-.6.2-1.2.2-1.9 0-5.2-4.3-9.4-9.6-9.4-.5 0-1 0-1.5.1C7.7.3 6.7 0 5.7 0zM10 3.8c.8 0 1.5.1 2.1.3.6.2 1.1.4 1.5.7.4.3.7.6.9 1 .2.3.3.7.3 1 0 .3-.1.6-.4.9s-.5.3-.8.3c-.3 0-.6-.1-.8-.2-.2-.2-.4-.4-.6-.7-.2-.4-.5-.8-.8-1-.3-.2-.8-.3-1.5-.3s-1.2.1-1.6.4c-.4.2-.6.5-.6.8 0 .2.1.4.2.5.1.2.3.3.5.4.3.1.5.2.8.3.3.1.7.2 1.3.3.7.2 1.4.3 2 .5.6.2 1.1.4 1.6.7.4.3.8.6 1 1.1s.4 1 .4 1.6c0 .7-.2 1.4-.6 2-.4.6-1.1 1.1-1.9 1.4-.8.3-1.8.5-2.9.5-1.3 0-2.4-.2-3.3-.7-.6-.3-1.1-.8-1.5-1.3-.4-.6-.6-1.1-.6-1.6 0-.3.1-.6.4-.9.3-.2.6-.3.9-.3.3 0 .6.1.8.3.2.2.4.4.5.8.2.4.3.7.5.9.2.2.4.4.8.6.3.2.8.2 1.3.2.8 0 1.4-.2 1.8-.5.5-.3.7-.7.7-1.1 0-.4-.1-.6-.4-.9-.2-.2-.6-.4-1-.5-.4-.1-1-.3-1.7-.4-.9-.2-1.8-.4-2.4-.7-.4-.3-1-.7-1.3-1.2-.4-.5-.7-1.1-.7-1.8s.2-1.3.6-1.8c.4-.5 1-.9 1.8-1.2.8-.3 1.7-.4 2.7-.4z"/>
				</svg>
			'
			],

			'github' => [
				'name' => 'GitHub',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M8.9,0.4C4.3,0.9,0.6,4.6,0.1,9.1c-0.5,4.7,2.2,8.9,6.3,10.5C6.7,19.7,7,19.5,7,19.1v-1.6c0,0-0.4,0.1-0.9,0.1c-1.4,0-2-1.2-2.1-1.9c-0.1-0.4-0.3-0.7-0.6-1C3.1,14.6,3,14.6,3,14.5c0-0.2,0.3-0.2,0.4-0.2c0.6,0,1.1,0.7,1.3,1c0.5,0.8,1.1,1,1.4,1c0.4,0,0.7-0.1,0.9-0.2c0.1-0.7,0.4-1.4,1-1.8c-2.3-0.5-4-1.8-4-4c0-1.1,0.5-2.2,1.2-3C5.1,7.1,5,6.6,5,5.9c0-0.4,0-1,0.3-1.6c0,0,1.4,0,2.8,1.3C8.6,5.4,9.3,5.3,10,5.3s1.4,0.1,2,0.3c1.3-1.3,2.8-1.3,2.8-1.3C15,4.9,15,5.5,15,5.9c0,0.8-0.1,1.2-0.2,1.4c0.7,0.8,1.2,1.8,1.2,3c0,2.2-1.7,3.5-4,4c0.6,0.5,1,1.4,1,2.3v2.6c0,0.3,0.3,0.6,0.7,0.5c3.7-1.5,6.3-5.1,6.3-9.3C20,4.4,14.9-0.3,8.9,0.4z"/>
				</svg>
			'
			],

			'gitlab' => [
				'name' => 'GitLab',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M15.7.9c-.2 0-.4.1-.4.3l-2.2 6.7H6.9L4.8 1.2C4.7 1 4.5.9 4.4.9c-.2 0-.4.1-.5.3l-2.6 7L0 11.6c0 .2 0 .4.2.5l9.6 7h.1l9.6-7c.5-.1.5-.3.5-.5l-1.3-3.5-2.6-7c-.1-.1-.3-.2-.4-.2zM2.6 8.7h3.7l2.5 7.8-6.2-7.8zm11.1 0h3.7l-6.2 7.8 2.5-7.8zm-11.8.4l5.8 7.3L1 11.6l.9-2.5zm16.2 0l.9 2.4-6.7 4.9 5.8-7.3z"/>
				</svg>
			'
			],

			'youtube' => [
				'name' => 'YouTube',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewbox="-21 -117 682.66672 682">
					<path d="m626.8125 64.035156c-7.375-27.417968-28.992188-49.03125-56.40625-56.414062-50.082031-13.703125-250.414062-13.703125-250.414062-13.703125s-200.324219 0-250.40625 13.183593c-26.886719 7.375-49.03125 29.519532-56.40625 56.933594-13.179688 50.078125-13.179688 153.933594-13.179688 153.933594s0 104.378906 13.179688 153.933594c7.382812 27.414062 28.992187 49.027344 56.410156 56.410156 50.605468 13.707031 250.410156 13.707031 250.410156 13.707031s200.324219 0 250.40625-13.183593c27.417969-7.378907 49.03125-28.992188 56.414062-56.40625 13.175782-50.082032 13.175782-153.933594 13.175782-153.933594s.527344-104.382813-13.183594-154.460938zm-370.601562 249.878906v-191.890624l166.585937 95.945312zm0 0"/>
				</svg>
			'
			],

			'vimeo' => [
				'name' => 'Vimeo',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M20,5.3c-0.1,1.9-1.4,4.6-4.1,8c-2.7,3.5-5,5.3-6.9,5.3c-1.2,0-2.2-1.1-3-3.2C4.5,9.7,3.8,6.3,2.5,6.3c-0.2,0-0.7,0.3-1.6,0.9L0,6c2.3-2,4.5-4.3,5.9-4.4c1.6-0.2,2.5,0.9,2.9,3.2c1.3,8.1,1.8,9.3,4.2,5.7c0.8-1.3,1.3-2.3,1.3-3c0.2-2-1.6-1.9-2.8-1.4c1-3.2,2.9-4.8,5.6-4.7C19.1,1.4,20.1,2.7,20,5.3L20,5.3z"/>
				</svg>
			'
			],

			'dtube' => [
				'name' => 'DTube',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M18.2,6c-0.4-1.2-1.1-2.3-1.9-3.2c-0.8-0.9-1.8-1.6-2.9-2C12.3,0.2,11,0,9.6,0H1.1v20h8.2c1.3,0,2.4-0.2,3.4-0.5c1-0.3,1.9-0.8,2.7-1.4c1.1-0.9,2-2,2.6-3.3c0.6-1.4,0.9-2.9,0.9-4.7C18.9,8.6,18.7,7.2,18.2,6z M6.1,14.5v-9l7.8,4.5L6.1,14.5z"/>
				</svg>
			'
			],

			'vk' => [
				'name' => 'VK',
				'icon' => '
				<svg
				class="rt-icon"
				width="20px"
				height="20"
				viewBox="0 0 20 20">
					<path d="M19.2,4.8H16c-0.3,0-0.5,0.1-0.6,0.4c0,0-1.3,2.4-1.7,3.2c-1.1,2.2-1.8,1.5-1.8,0.5V5.4c0-0.6-0.5-1.1-1.1-1.1H8.2C7.6,4.3,6.9,4.6,6.5,5.1c0,0,1.2-0.2,1.2,1.5c0,0.4,0,1.6,0,2.6c0,0.4-0.3,0.7-0.7,0.7c-0.2,0-0.4-0.1-0.6-0.2c-1-1.4-1.8-2.9-2.5-4.5C4,5,3.7,4.8,3.5,4.8c-0.7,0-2.1,0-2.9,0C0.2,4.8,0,5,0,5.3c0,0.1,0,0.1,0,0.2C0.9,8,4.8,15.7,9.2,15.7H11c0.4,0,0.7-0.3,0.7-0.7v-1.1c0-0.4,0.3-0.7,0.7-0.7c0.2,0,0.4,0.1,0.5,0.2l2.2,2.1c0.2,0.2,0.5,0.3,0.7,0.3h2.9c1.4,0,1.4-1,0.6-1.7c-0.5-0.5-2.5-2.6-2.5-2.6c-0.3-0.4-0.4-0.9-0.1-1.3c0.6-0.8,1.7-2.2,2.1-2.8C19.6,6.5,20.7,4.8,19.2,4.8z"/>
				</svg>
			',
			],

			'ok' => [
				'name' => 'Odnoklassniki',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 24 24">
					<path d="m4.721 12.881c-.613 1.205.083 1.781 1.671 2.765 1.35.834 3.215 1.139 4.413 1.261-.491.472 1.759-1.692-4.721 4.541-1.374 1.317.838 3.43 2.211 2.141l3.717-3.585c1.423 1.369 2.787 2.681 3.717 3.59 1.374 1.294 3.585-.801 2.226-2.141-.102-.097-5.037-4.831-4.736-4.541 1.213-.122 3.05-.445 4.384-1.261l-.001-.001c1.588-.989 2.284-1.564 1.68-2.769-.365-.684-1.349-1.256-2.659-.267 0 0-1.769 1.355-4.622 1.355-2.854 0-4.622-1.355-4.622-1.355-1.309-.994-2.297-.417-2.658.267z"/><path d="m11.999 12.142c3.478 0 6.318-2.718 6.318-6.064 0-3.36-2.84-6.078-6.318-6.078-3.479 0-6.319 2.718-6.319 6.078 0 3.346 2.84 6.064 6.319 6.064zm0-9.063c1.709 0 3.103 1.341 3.103 2.999 0 1.644-1.394 2.985-3.103 2.985s-3.103-1.341-3.103-2.985c-.001-1.659 1.393-2.999 3.103-2.999z"/>
				</svg>
			',
			],

			'rss' => [
				'name' => 'RSS',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 448 448" style="enable-background:new 0 0 448 448;" xml:space="preserve"><circle cx="64" cy="384" r="64"/>
					<path d="M0,149.344v85.344c117.632,0,213.344,95.68,213.344,213.312h85.312C298.656,283.328,164.672,149.344,0,149.344z"/><path d="M0,0v85.344C200,85.344,362.688,248,362.688,448H448C448,200.96,247.04,0,0,0z"/>
				</svg>'
			],

			'facebook_group' => [
				'name' => 'Facebook Group',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M3.3,18.4c-0.2-0.5,0.3-2.8,0.7-3.7c0.5-1.1,1.6-2,2.5-2.3c0.6-0.2,0.7-0.2,2.1,0.5l1.4,0.7l1.4-0.7c0.8-0.4,1.5-0.7,1.8-0.7c0.5,0,1.8,0.9,2.4,1.6c0.6,0.9,1.1,2.3,1.2,3.7l0,1.1l-6.7,0C4,18.7,3.4,18.6,3.3,18.4z M0.1,12.8c-0.4-0.9,0.6-3.4,1.6-4.1c0.8-0.5,1.5-0.5,2.5,0.1c0.6,0.4,0.9,0.5,1.1,0.3C5.6,9,5.7,9,5.9,9.3c0.2,0.2,0.6,0.6,0.9,1c0.6,0.6,0.6,0.7-0.4,1.1c-0.4,0.1-1.1,0.5-1.6,1l-0.9,0.7H2.1C0.5,13.1,0.2,13,0.1,12.8z M15.3,12.4c-0.4-0.4-1.1-0.8-1.5-1c-1.1-0.4-1.1-0.5-0.5-1.1c0.3-0.3,0.7-0.7,0.9-1C14.4,9,14.5,9,14.8,9.1c0.2,0.1,0.5,0,1.1-0.3c0.5-0.3,1.1-0.5,1.4-0.5c1.3,0,2.6,1.8,2.7,3.7l0,1l-2,0l-2,0L15.3,12.4z M8.4,10.6C7,9.9,6,8.4,6,6.9c0-2.1,2-4.1,4.1-4.1s4.1,2,4.1,4.1S12.1,11,10,11C9.6,11,8.9,10.8,8.4,10.6z M3.5,6.8c-1.7-1-1.9-3.5-0.4-4.7c1.1-0.9,2.5-1,3.6-0.2c1,0.7,1,0.9,0.2,1.6c-0.8,0.7-1.4,1.8-1.5,3C5.2,7.2,5.2,7.3,4.7,7.3C4.4,7.3,3.9,7.1,3.5,6.8z M14.8,6.5c-0.2-1.2-0.7-2.3-1.5-3c-0.8-0.7-0.8-0.9,0.2-1.6C15.4,0.6,18,2,18,4.3c0,1.5-1.4,3-2.7,3C14.9,7.3,14.9,7.2,14.8,6.5z"/>
				</svg>
			',
			],

			'discord' => [
				'name' => 'Discord',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M17.2,4.2c-1.7-1.4-4.5-1.6-4.6-1.6c-0.2,0-0.4,0.1-0.4,0.3c0,0-0.1,0.1-0.1,0.4c1.1,0.2,2.6,0.6,3.8,1.4C16.1,4.7,16.2,5,16,5.2c-0.1,0.1-0.2,0.2-0.4,0.2c-0.1,0-0.2,0-0.2-0.1C13.3,4,10.5,3.9,10,3.9S6.7,4,4.6,5.3C4.4,5.5,4.1,5.4,4,5.2C3.8,5,3.9,4.7,4.1,4.6c1.3-0.8,2.7-1.2,3.8-1.4C7.9,3,7.8,2.9,7.8,2.9C7.7,2.7,7.5,2.6,7.4,2.6c-0.1,0-2.9,0.2-4.6,1.7C1.8,5.1,0,10.1,0,14.3c0,0.1,0,0.2,0.1,0.2c1.3,2.2,4.7,2.8,5.5,2.8c0,0,0,0,0,0c0.1,0,0.3-0.1,0.4-0.2l0.8-1.1c-2.1-0.6-3.2-1.5-3.3-1.6c-0.2-0.2-0.2-0.4,0-0.6c0.2-0.2,0.4-0.2,0.6,0c0,0,2,1.7,6,1.7c4,0,6-1.7,6-1.7c0.2-0.2,0.5-0.1,0.6,0c0.2,0.2,0.1,0.5,0,0.6c-0.1,0.1-1.2,1-3.3,1.6l0.8,1.1c0.1,0.1,0.2,0.2,0.4,0.2c0,0,0,0,0,0c0.8,0,4.2-0.6,5.5-2.8c0-0.1,0.1-0.1,0.1-0.2C20,10.1,18.2,5.1,17.2,4.2z M7.2,12.6c-0.8,0-1.5-0.8-1.5-1.7s0.7-1.7,1.5-1.7c0.8,0,1.5,0.8,1.5,1.7S8,12.6,7.2,12.6z M12.8,12.6c-0.8,0-1.5-0.8-1.5-1.7s0.7-1.7,1.5-1.7c0.8,0,1.5,0.8,1.5,1.7S13.7,12.6,12.8,12.6z"/>
				</svg>
			',
			],

			'tripadvisor' => [
				'name' => 'TripAdvisor',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M5.9 10.7c0 .4-.4.8-.8.8s-.8-.4-.8-.8.4-.8.8-.8.8.3.8.8zm1.7 0c0 1.3-1.1 2.4-2.4 2.4S2.7 12 2.7 10.7c0-1.3 1.1-2.4 2.4-2.4s2.5 1 2.5 2.4zm-.9 0c0-.9-.7-1.6-1.6-1.6-.9 0-1.6.7-1.6 1.6 0 .9.7 1.6 1.6 1.6.9 0 1.6-.7 1.6-1.6zm8.2-.8c-.4 0-.8.4-.8.8s.4.8.8.8.8-.4.8-.8c0-.5-.4-.8-.8-.8zm2.4.8c0 1.3-1.1 2.4-2.4 2.4s-2.4-1.1-2.4-2.4c0-1.3 1.1-2.4 2.4-2.4s2.4 1 2.4 2.4zm-.8 0c0-.9-.7-1.6-1.6-1.6-.9 0-1.6.7-1.6 1.6 0 .9.7 1.6 1.6 1.6.9 0 1.6-.7 1.6-1.6zm1.6 4.1c-2.1 1.7-5.2 1.3-6.9-.8l-.9 1.5c0 .1-.1.1-.1.1-.2.1-.4.1-.6-.1L8.7 14c-1.7 2.1-4.7 2.5-6.9.8-2-1.7-2.4-4.8-.8-6.9-.1-.5-.4-1-.7-1.4 0-.1-.1-.2-.1-.3 0-.2.2-.4.4-.4h3.1c3.9-2.2 8.7-2.2 12.6 0h3.1c.1 0 .2 0 .3.1.2.1.2.4 0 .6-.3.4-.6.9-.8 1.4 1.7 2.1 1.3 5.2-.8 6.9zm-8.9-4.1c0-2.2-1.8-4.1-4.1-4.1h-1C2.3 7.1 1 8.8 1 10.7c0 2.2 1.9 4 4.1 4 2.3.1 4.1-1.8 4.1-4zm6.6-4h-.2c-.2 0-.5-.1-.7-.1-2.2 0-4 1.7-4.1 3.9 0 .7.2 1.4.5 2.1.1.1.1.2.2.3.8 1.1 2 1.8 3.4 1.8 1.9 0 3.5-1.3 3.9-3.1.5-2.1-.8-4.3-3-4.9z"/>
				</svg>
			',
			],

			'foursquare' => [
				'name' => 'Foursquare',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M14.8 2.9l-.4 2.3c-.1.3-.4.5-.7.5H9.5c-.5 0-.8.4-.8.8V7c0 .5.3.8.8.8H13c.3 0 .7.4.6.7l-.4 2.3c0 .2-.3.5-.7.5H9.6c-.5 0-.7.1-1 .5-.3.4-3.5 4.2-3.5 4.2H5V2.8c0-.3.3-.6.6-.6h8.6c.4 0 .7.3.6.7zm.3 9.1c.1-.5 1.5-7.3 1.9-9.5M15.4 0H4.7C3.3 0 2.8 1.1 2.8 1.8v16.9c0 .8.4 1.1.7 1.2.2.1.9.2 1.3-.3 0 0 5-5.8 5.1-5.9.1-.1.1-.1.3-.1h3.3c1.4 0 1.6-1 1.7-1.5.1-.5 1.5-7.3 1.9-9.5C17.4.9 17 0 15.4 0z"/>
				</svg>
			',
			],

			'yelp' => [
				'name' => 'Yelp',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M18.8 14.4c0 .4-.3.8-.3.9l-2.1 2.9-.1.1c-.1 0-.5.3-1 .3s-1-.6-1.1-.7l-2.7-4.2c-.3-.3-.3-1 .1-1.5.3-.3.5-.3.9-.3h.3l5 1.5c.3.1 1 .3 1 1zm-6.1-3.3l5-1.4c.2-.1.9-.3 1-.9.2-.5-.1-1-.2-1 0 0 0-.1-.1-.1L16 5.2c0-.1-.3-.5-1-.5s-1 .6-1 .7l-2.8 4.2c-.2.3-.3.8 0 1.2.3.2.6.3 1.1.3h.4zM9.9.2C9.3 0 8.9 0 8.6.1L4.4 1.4c-.1 0-.5.2-.9.6-.4.8.4 1.6.4 1.6l4.4 5.5c.1.1.4.4 1 .4h.3c.7-.2 1-.9 1-1.3V1.6c-.1-.2-.2-1.1-.7-1.4zM8 12.6c.3-.1.7-.3.7-1.1s-.8-1.1-.9-1.2L3.4 8.2c-.1 0-1-.3-1.3-.1-.2.1-.7.5-.7.9l-.3 3.3c0 .2 0 .7.2 1 .1.2.3.4.8.4.3 0 .6-.1.6-.1l5.1-1c.2.1.2 0 .2 0zm1.8.3c-.2-.1-.3-.1-.4-.1-.5 0-1 .3-1 .4l-3.5 3.6c-.1.2-.5.8-.3 1.3.2.4.3.7.8.9l3.5 1h.4c.2 0 .3 0 .4-.1.5-.2.7-.8.7-1.2l.1-4.9c0-.2-.2-.7-.7-.9z"/>
				</svg>
			',
			],

			'hacker_news' => [
				'name' => 'Hacker News',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M0,0v20h20V0H0z M11.2,11.8v4.7H8.8v-4.7L4.7,4.1h1.9l3.4,6l3.4-6h1.9L11.2,11.8z"/>
				</svg>
			',
			],

			'xing' => [
				'name' => 'Xing',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 512 512">
					<polygon points="496,0 376.384,0 198.688,311.264 313.184,512 432.8,512 318.304,311.264"/>
					<polygon points="149.216,96 36.448,96 101.696,210.912 16,352 128.768,352 214.464,210.912"/>
				</svg>
			'
			],

			'whatsapp' => [
				'name' => 'WhatsApp',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="-23 -21 682 682.66669">
					<path d="m544.386719 93.007812c-59.875-59.945312-139.503907-92.9726558-224.335938-93.007812-174.804687 0-317.070312 142.261719-317.140625 317.113281-.023437 55.894531 14.578125 110.457031 42.332032 158.550781l-44.992188 164.335938 168.121094-44.101562c46.324218 25.269531 98.476562 38.585937 151.550781 38.601562h.132813c174.785156 0 317.066406-142.273438 317.132812-317.132812.035156-84.742188-32.921875-164.417969-92.800781-224.359376zm-224.335938 487.933594h-.109375c-47.296875-.019531-93.683594-12.730468-134.160156-36.742187l-9.621094-5.714844-99.765625 26.171875 26.628907-97.269531-6.269532-9.972657c-26.386718-41.96875-40.320312-90.476562-40.296875-140.28125.054688-145.332031 118.304688-263.570312 263.699219-263.570312 70.40625.023438 136.589844 27.476562 186.355469 77.300781s77.15625 116.050781 77.132812 186.484375c-.0625 145.34375-118.304687 263.59375-263.59375 263.59375zm144.585938-197.417968c-7.921875-3.96875-46.882813-23.132813-54.148438-25.78125-7.257812-2.644532-12.546875-3.960938-17.824219 3.96875-5.285156 7.929687-20.46875 25.78125-25.09375 31.066406-4.625 5.289062-9.242187 5.953125-17.167968 1.984375-7.925782-3.964844-33.457032-12.335938-63.726563-39.332031-23.554687-21.011719-39.457031-46.960938-44.082031-54.890626-4.617188-7.9375-.039062-11.8125 3.476562-16.171874 8.578126-10.652344 17.167969-21.820313 19.808594-27.105469 2.644532-5.289063 1.320313-9.917969-.664062-13.882813-1.976563-3.964844-17.824219-42.96875-24.425782-58.839844-6.4375-15.445312-12.964843-13.359374-17.832031-13.601562-4.617187-.230469-9.902343-.277344-15.1875-.277344-5.28125 0-13.867187 1.980469-21.132812 9.917969-7.261719 7.933594-27.730469 27.101563-27.730469 66.105469s28.394531 76.683594 32.355469 81.972656c3.960937 5.289062 55.878906 85.328125 135.367187 119.648438 18.90625 8.171874 33.664063 13.042968 45.175782 16.695312 18.984374 6.03125 36.253906 5.179688 49.910156 3.140625 15.226562-2.277344 46.878906-19.171875 53.488281-37.679687 6.601563-18.511719 6.601563-34.375 4.617187-37.683594-1.976562-3.304688-7.261718-5.285156-15.183593-9.253906zm0 0" fill-rule="evenodd"/>
				</svg>
			',
			],

			'flipboard' => [
				'name' => 'Flipboard',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M0 0v20h20V0H0zm16 8h-4v4H8v4H4V4h12v4z"/>
				</svg>
			',
			],

			'viber' => [
				'name' => 'Viber',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 24 24">
					<path d="m23.155 13.893c.716-6.027-.344-9.832-2.256-11.553l.001-.001c-3.086-2.939-13.508-3.374-17.2.132-1.658 1.715-2.242 4.232-2.306 7.348-.064 3.117-.14 8.956 5.301 10.54h.005l-.005 2.419s-.037.98.589 1.177c.716.232 1.04-.223 3.267-2.883 3.724.323 6.584-.417 6.909-.525.752-.252 5.007-.815 5.695-6.654zm-12.237 5.477s-2.357 2.939-3.09 3.702c-.24.248-.503.225-.499-.267 0-.323.018-4.016.018-4.016-4.613-1.322-4.341-6.294-4.291-8.895.05-2.602.526-4.733 1.93-6.168 3.239-3.037 12.376-2.358 14.704-.17 2.846 2.523 1.833 9.651 1.839 9.894-.585 4.874-4.033 5.183-4.667 5.394-.271.09-2.786.737-5.944.526z"/><path d="m12.222 4.297c-.385 0-.385.6 0 .605 2.987.023 5.447 2.105 5.474 5.924 0 .403.59.398.585-.005h-.001c-.032-4.115-2.718-6.501-6.058-6.524z"/><path d="m16.151 10.193c-.009.398.58.417.585.014.049-2.269-1.35-4.138-3.979-4.335-.385-.028-.425.577-.041.605 2.28.173 3.481 1.729 3.435 3.716z"/><path d="m15.521 12.774c-.494-.286-.997-.108-1.205.173l-.435.563c-.221.286-.634.248-.634.248-3.014-.797-3.82-3.951-3.82-3.951s-.037-.427.239-.656l.544-.45c.272-.216.444-.736.167-1.247-.74-1.337-1.237-1.798-1.49-2.152-.266-.333-.666-.408-1.082-.183h-.009c-.865.506-1.812 1.453-1.509 2.428.517 1.028 1.467 4.305 4.495 6.781 1.423 1.171 3.675 2.371 4.631 2.648l.009.014c.942.314 1.858-.67 2.347-1.561v-.007c.217-.431.145-.839-.172-1.106-.562-.548-1.41-1.153-2.076-1.542z"/><path d="m13.169 8.104c.961.056 1.427.558 1.477 1.589.018.403.603.375.585-.028-.064-1.346-.766-2.096-2.03-2.166-.385-.023-.421.582-.032.605z"/>
				</svg>
			',
			],

			'telegram' => [
				'name' => 'Telegram',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M19.9,3.1l-3,14.2c-0.2,1-0.8,1.3-1.7,0.8l-4.6-3.4l-2.2,2.1c-0.2,0.2-0.5,0.5-0.9,0.5l0.3-4.7L16.4,5c0.4-0.3-0.1-0.5-0.6-0.2L5.3,11.4L0.7,10c-1-0.3-1-1,0.2-1.5l17.7-6.8C19.5,1.4,20.2,1.9,19.9,3.1z"/>
				</svg>
			',
			],

			'weibo' => [
				'name' => 'Weibo',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M15.9,7.6c0.3-0.9-0.5-1.8-1.5-1.6c-0.9,0.2-1.1-1.1-0.3-1.3c2-0.4,3.6,1.4,3,3.3C16.9,8.8,15.6,8.4,15.9,7.6z M8.4,18.1c-4.2,0-8.4-2-8.4-5.3C0,11,1.1,9,3,7.2c3.9-3.9,7.9-3.9,6.8-0.2c-0.2,0.5,0.5,0.2,0.5,0.2c3.1-1.3,5.5-0.7,4.5,2c-0.1,0.4,0,0.4,0.3,0.5C20.3,11.3,16.4,18.1,8.4,18.1L8.4,18.1zM14,12.4c-0.2-2.2-3.1-3.7-6.4-3.3C4.3,9.4,1.8,11.4,2,13.6s3.1,3.7,6.4,3.3C11.7,16.6,14.2,14.6,14,12.4zM13.6,2c-1,0.2-0.7,1.7,0.3,1.5c2.8-0.6,5.3,2.1,4.4,4.8c-0.3,0.9,1.1,1.4,1.5,0.5C21,4.9,17.6,1.2,13.6,2L13.6,2z M10.5,14.2c-0.7,1.5-2.6,2.3-4.3,1.8c-1.6-0.5-2.3-2.1-1.6-3.5c0.7-1.4,2.5-2.2,4-1.8C10.4,11.1,11.2,12.7,10.5,14.2zM7.2,13c-0.5-0.2-1.2,0-1.5,0.5C5.3,14,5.5,14.6,6,14.8c0.5,0.2,1.2,0,1.5-0.5C7.8,13.8,7.7,13.2,7.2,13zM8.4,12.5c-0.2-0.1-0.4,0-0.6,0.2c-0.1,0.2-0.1,0.4,0.1,0.5c0.2,0.1,0.5,0,0.6-0.2C8.7,12.8,8.6,12.6,8.4,12.5z"/>
				</svg>
			'
			],

			'tumblr' => [
				'name' => 'Tumblr',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 24 24">
					<path d="m19 22.594-1.175-3.425c-.458.214-1.327.399-1.968.419h-.091c-1.863 0-2.228-1.37-2.244-2.371v-7.47h4.901v-3.633h-4.883v-6.114h-3.575c-.059 0-.162.051-.176.179-.202 1.873-1.098 5.156-4.789 6.469v3.099h2.456v7.842c0 2.655 1.97 6.411 7.148 6.411l-.011-.002h.181c1.786-.03 3.783-.768 4.226-1.404z"/>
				</svg>
			'
			],

			'getpocket' => [
				'name' => 'Getpocket',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 24 24">
				<path d="M0,10.7c0,6.702,5.341,12.05,12.01,12.05C18.654,22.75,24,17.402,24,10.7V3.432c0-1.204-0.949-2.182-2.165-2.182H2.175C0.991,1.25,0,2.244,0,3.432V10.7z M6.374,7.41c0.911,0,0.863,0.204,5.635,4.8c4.854-4.67,4.746-4.8,5.651-4.8c0.905,0,1.645,0.742,1.645,1.65c0,0.956-0.156,0.844-6.15,6.622h0.001c-0.664,0.634-1.682,0.596-2.272,0c-6.091-5.854-6.155-5.65-6.155-6.622C4.729,8.152,5.468,7.41,6.374,7.41z"/></svg>
					<path d="m19 22.594-1.175-3.425c-.458.214-1.327.399-1.968.419h-.091c-1.863 0-2.228-1.37-2.244-2.371v-7.47h4.901v-3.633h-4.883v-6.114h-3.575c-.059 0-.162.051-.176.179-.202 1.873-1.098 5.156-4.789 6.469v3.099h2.456v7.842c0 2.655 1.97 6.411 7.148 6.411l-.011-.002h.181c1.786-.03 3.783-.768 4.226-1.404z"/>
				</svg>
			'
			],
			'line' => [
				'name' => 'Line',
				'icon' => '
				<svg 
				width="20"
				height="20"
				viewBox="0 0 296.528 296.528"
				x="0px" y="0px"><g><path d="M295.838,115.347l0.003-0.001l-0.092-0.76c-0.001-0.013-0.002-0.023-0.004-0.036c-0.001-0.011-0.002-0.021-0.004-0.032 l-0.344-2.858c-0.069-0.574-0.148-1.228-0.238-1.974l-0.072-0.594l-0.147,0.018c-3.617-20.571-13.553-40.093-28.942-56.762 c-15.317-16.589-35.217-29.687-57.548-37.878c-19.133-7.018-39.434-10.577-60.337-10.577c-28.22,0-55.627,6.637-79.257,19.193 C23.289,47.297-3.585,91.799,0.387,136.461c2.056,23.111,11.11,45.11,26.184,63.621c14.188,17.423,33.381,31.483,55.503,40.66 c13.602,5.642,27.051,8.301,41.291,11.116l1.667,0.33c3.921,0.776,4.975,1.842,5.247,2.264c0.503,0.784,0.24,2.329,0.038,3.18 c-0.186,0.785-0.378,1.568-0.57,2.352c-1.529,6.235-3.11,12.683-1.868,19.792c1.428,8.172,6.531,12.859,14.001,12.86 c0.001,0,0.001,0,0.002,0c8.035,0,17.18-5.39,23.231-8.956l0.808-0.475c14.436-8.478,28.036-18.041,38.271-25.425 c22.397-16.159,47.783-34.475,66.815-58.17C290.172,175.745,299.2,145.078,295.838,115.347z M92.343,160.561H66.761 c-3.866,0-7-3.134-7-7V99.865c0-3.866,3.134-7,7-7c3.866,0,7,3.134,7,7v46.696h18.581c3.866,0,7,3.134,7,7 C99.343,157.427,96.209,160.561,92.343,160.561z M119.03,153.371c0,3.866-3.134,7-7,7c-3.866,0-7-3.134-7-7V99.675 c0-3.866,3.134-7,7-7c3.866,0,7,3.134,7,7V153.371z M182.304,153.371c0,3.033-1.953,5.721-4.838,6.658 c-0.712,0.231-1.441,0.343-2.161,0.343c-2.199,0-4.323-1.039-5.666-2.888l-25.207-34.717v30.605c0,3.866-3.134,7-7,7 c-3.866,0-7-3.134-7-7v-52.16c0-3.033,1.953-5.721,4.838-6.658c2.886-0.936,6.045,0.09,7.827,2.545l25.207,34.717V99.675 c0-3.866,3.134-7,7-7c3.866,0,7,3.134,7,7V153.371z M233.311,159.269h-34.645c-3.866,0-7-3.134-7-7v-26.847V98.573 c0-3.866,3.134-7,7-7h33.57c3.866,0,7,3.134,7,7s-3.134,7-7,7h-26.57v12.849h21.562c3.866,0,7,3.134,7,7c0,3.866-3.134,7-7,7 h-21.562v12.847h27.645c3.866,0,7,3.134,7,7S237.177,159.269,233.311,159.269z"/></g></svg>
			'
			],

			'evernote' => [
				'name' => 'Evernote',
				'icon' => '
				<svg 
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 40 48">
				 	<path d="M834.793 1065.704a9.585 9.585 0 0 0-1.847.111c.163-1.321.707-2.944 2.633-2.877 2.132.075 2.43 2.097 2.438 3.468-.9-.403-2.012-.658-3.224-.702m9.117-14.353c-.357-1.916-1.491-2.86-2.518-3.23-1.105-.402-3.35-.817-6.169-1.152-2.268-.267-4.933-.246-6.544-.196-.192-1.33-1.12-2.543-2.16-2.963-2.767-1.119-7.045-.849-8.141-.54-.873.245-1.84.747-2.377 1.52-.36.516-.593 1.179-.595 2.103 0 .523.015 1.755.027 2.85.013 1.098.028 2.08.028 2.088 0 .976-.79 1.773-1.769 1.774h-4.486c-.958 0-1.69.162-2.247.416-.56.256-.956.6-1.258 1.006-.6.809-.704 1.805-.7 2.822 0 0 .008.832.208 2.44.166 1.245 1.51 9.944 2.788 12.588.495 1.03.825 1.458 1.797 1.911 2.168.933 7.121 1.97 9.441 2.267 2.318.297 3.771.922 4.638-.902.003-.004.173-.454.408-1.113.753-2.289.857-4.32.857-5.788 0-.15.219-.156.219 0 0 1.036-.198 4.708 2.565 5.694 1.09.388 3.352.733 5.65 1.005 2.079.24 3.588 1.06 3.588 6.414 0 3.256-.682 3.703-4.244 3.703-2.888 0-3.989.075-3.989-2.227 0-1.862 1.835-1.667 3.193-1.667.608 0 .167-.453.167-1.602 0-1.143.712-1.803.04-1.82-4.701-.13-7.466-.005-7.466 5.896 0 5.358 2.042 6.352 8.711 6.352 5.231 0 7.075-.172 9.234-6.898.427-1.33 1.46-5.38 2.085-12.186.396-4.302-.372-17.288-.981-20.565m-34.915.946h4.49a.467.467 0 0 0 .464-.466c0-.002-.053-3.863-.053-4.937v-.013c0-.882.183-1.65.505-2.295l.154-.288a.088.088 0 0 0-.053.027l-8.718 8.68a.1.1 0 0 0-.032.051c.18-.09.427-.211.461-.226.76-.345 1.68-.533 2.782-.533" transform="translate(-805 -1043)"/>
				</svg>
			'],

			'threema' => [
				'name' => 'Threema',
				'icon' => '
				<svg 
				class="rt-icon"
				width="20"
				height="20"
				x="0px" 
				y="0px"
				viewBox="0 0 278.7 323.3"
				version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g id="Threema-Logo"><g id="Threema:-Wortmarke-_x2B_-Bildmarke-_x2B_-Claim-_x28_Landscape_x29_" transform="translate(-200.000000, -342.000000)"><path d="M425,618c13.1,0,23.7,10.6,23.7,23.7c0,13.1-10.6,23.7-23.7,23.7c-13.1,0-23.6-10.6-23.6-23.7 C401.4,628.6,411.9,618,425,618z M254.4,618c13.1,0,23.7,10.6,23.7,23.7c0,13.1-10.6,23.7-23.7,23.7c-13.1,0-23.6-10.6-23.6-23.7 C230.7,628.6,241.3,618,254.4,618z M339.7,618c13.1,0,23.7,10.6,23.7,23.7c0,13.1-10.6,23.7-23.7,23.7 c-13.1,0-23.6-10.6-23.6-23.7C316,628.6,326.6,618,339.7,618z M339.7,342.1c76.8,0,139,54.8,139,122.3s-62.2,122.3-139,122.3 c-21.8,0-42.5-4.4-60.9-12.3l-69.6,17.4l14.9-59.5c-14.7-19.4-23.3-42.8-23.3-67.9C200.7,396.9,262.9,342.1,339.7,342.1z M339.7,399.2c-21.8,0-39.4,17.6-39.4,39.4v15.7h-1.5c-3.5,0-6.3,2.8-6.3,6.3v55.6c0,3.5,2.8,6.3,6.3,6.3h82 c3.5,0,6.3-2.8,6.3-6.3v-55.6c0-3.5-2.8-6.3-6.3-6.3h-1.5v-15.7C379.1,416.8,361.5,399.2,339.7,399.2z M339.7,414.9 c13.1,0,23.7,10.6,23.7,23.6v15.7H316v-15.7C316,425.5,326.6,414.9,339.7,414.9z"/></g></g></svg>
			'
			],

			'qq' => [
				'name' => 'QQ',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M18.2,16.4c-0.5,0.1-1.8-2.1-1.8-2.1c0,1.2-0.6,2.8-2,4c0.7,0.2,2.1,0.7,1.8,1.3C16,20.2,11.3,20,10,19.8c-1.3,0.2-5.9,0.3-6.2-0.2c-0.4-0.6,1.1-1.1,1.8-1.3c-1.4-1.2-2-2.8-2-4c0,0-1.3,2.1-1.8,2.1c-0.2,0-0.5-1.2,0.4-3.9c0.4-1.3,0.9-2.4,1.6-4.1C3.6,3.8,5.5,0,10,0c4.4,0,6.4,3.8,6.3,8.4c0.7,1.8,1.2,2.8,1.6,4.1C18.7,15.3,18.4,16.4,18.2,16.4L18.2,16.4z"/>
				</svg>
			'
			],

			'wechat' => [
				'name' => 'WeChat',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M13.5,6.8c0.2,0,0.5,0,0.7,0c-0.6-2.9-3.7-5-7.1-5C3.2,1.9,0,4.5,0,7.9c0,1.9,1.1,3.5,2.8,4.8l-0.7,2.1l2.5-1.2c0.9,0.2,1.6,0.4,2.5,0.4c0.2,0,0.4,0,0.7,0c-0.1-0.5-0.2-1-0.2-1.5C7.5,9.3,10.2,6.8,13.5,6.8L13.5,6.8zM9.7,4.9c0.5,0,0.9,0.4,0.9,0.9c0,0.5-0.4,0.9-0.9,0.9c-0.5,0-1.1-0.4-1.1-0.9C8.7,5.2,9.2,4.9,9.7,4.9zM4.8,6.6c-0.5,0-1.1-0.4-1.1-0.9c0-0.5,0.5-0.9,1.1-0.9c0.5,0,0.9,0.4,0.9,0.9C5.7,6.3,5.3,6.6,4.8,6.6z M20,12.3c0-2.8-2.8-5.1-6-5.1c-3.4,0-6,2.3-6,5.1s2.6,5.1,6,5.1c0.7,0,1.4-0.2,2.1-0.4l1.9,1.1l-0.5-1.8C18.9,15.3,20,13.9,20,12.3zM12,11.4c-0.4,0-0.7-0.4-0.7-0.7c0-0.4,0.4-0.7,0.7-0.7c0.5,0,0.9,0.4,0.9,0.7C12.9,11.1,12.6,11.4,12,11.4zM15.9,11.4c-0.4,0-0.7-0.4-0.7-0.7c0-0.4,0.4-0.7,0.7-0.7c0.5,0,0.9,0.4,0.9,0.7C16.8,11.1,16.5,11.4,15.9,11.4z"/>
				</svg>
			'
			],

			'strava' => [
				'name' => 'Strava',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M12.3,13.9l-1.4-2.7h2.8L12.3,13.9z M20,3v14c0,1.7-1.3,3-3,3H3c-1.7,0-3-1.3-3-3V3c0-1.7,1.3-3,3-3h14C18.7,0,20,1.3,20,3zM15.8,11.1h-2.1L9,2l-4.7,9.1H7L9,7.5l1.9,3.6H8.8l3.5,6.9L15.8,11.1z"/>
				</svg>
			'
			],

			'flickr' => [
				'name' => 'Flickr',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20">
					<path d="M4.7 14.7C2.1 14.8 0 12.6 0 10c0-2.5 2.1-4.7 4.8-4.7 2.6 0 4.7 2.1 4.7 4.8 0 2.6-2.2 4.7-4.8 4.6z"/>
					<path d="M15.3 5.3C18 5.3 20 7.5 20 10c0 2.6-2.1 4.7-4.7 4.7-2.5 0-4.7-2-4.7-4.7-.1-2.6 2-4.7 4.7-4.7z"/>
				</svg>
			'
			],

			'phone' => [
				'name' => 'Phone',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 513.64 513.64">
					<path d="M499.66,376.96l-71.68-71.68c-25.6-25.6-69.12-15.359-79.36,17.92c-7.68,23.041-33.28,35.841-56.32,30.72
					c-51.2-12.8-120.32-79.36-133.12-133.12c-7.68-23.041,7.68-48.641,30.72-56.32c33.28-10.24,43.52-53.76,17.92-79.36l-71.68-71.68
					c-20.48-17.92-51.2-17.92-69.12,0l-48.64,48.64c-48.64,51.2,5.12,186.88,125.44,307.2c120.32,120.32,256,176.641,307.2,125.44
					l48.64-48.64C517.581,425.6,517.581,394.88,499.66,376.96z"/>
				</svg>
			'
			],

			'email' => [
				'name' => 'Email',
				'icon' => '
				<svg
				class="rt-icon"
				width="20"
				height="20"
				viewBox="0 0 479.058 479.058">
					<path d="m434.146 59.882h-389.234c-24.766 0-44.912 20.146-44.912 44.912v269.47c0 24.766 20.146 44.912 44.912 44.912h389.234c24.766 0 44.912-20.146 44.912-44.912v-269.47c0-24.766-20.146-44.912-44.912-44.912zm0 29.941c2.034 0 3.969.422 5.738 1.159l-200.355 173.649-200.356-173.649c1.769-.736 3.704-1.159 5.738-1.159zm0 299.411h-389.234c-8.26 0-14.971-6.71-14.971-14.971v-251.648l199.778 173.141c2.822 2.441 6.316 3.655 9.81 3.655s6.988-1.213 9.81-3.655l199.778-173.141v251.649c-.001 8.26-6.711 14.97-14.971 14.97z"/>
				</svg>
			'
			],
		];

		foreach ( rishi__cb_customizer_get_dynamic_social_networks() as $dynamic_network ) {
			$metadata[ $dynamic_network['id'] ] = array(
				'name' => $dynamic_network['name'],
				'icon' => $dynamic_network['icon'],
			);
		}

		if ( ! $args['social'] ) {
			return null;
		}

		if ( ! isset( $metadata[ $args['social'] ] ) ) {
			return null;
		}

		$single_metadata        = $metadata[ $args['social'] ];
		$single_metadata['url'] = '';

		if ( $args['type'] === 'url' ) {
			$single_metadata['url'] = esc_url( get_theme_mod( $args['social'], '#' ) );

			if ( empty( trim( $single_metadata['url'] ) ) ) {
				$single_metadata['url'] = '#';
			}
		}

		if ( $args['type'] === 'share' ) {
			$home_url = rishi__cb_customizer_encode_uri_component(
				get_the_permalink()
			);

			if ( ! empty( $args['custom_url'] ) ) {
				$home_url = rishi__cb_customizer_encode_uri_component( $args['custom_url'] );
			}

			$social_urls = array(
				'facebook'    => 'https://www.facebook.com/sharer/sharer.php?u={url}',
				'twitter'     => 'https://twitter.com/share?url={url}&text={text}',
				'pinterest'   => 'https://pinterest.com/pin/create/button/?url={url}&description={text}',
				'linkedin'    => 'https://www.linkedin.com/shareArticle?url={url}&title={text}',
				'email'       => 'mailto:?Subject={text}&Body={url}',
				'reddit'      => 'https://reddit.com/submit?url={url}&title={text}',
				'telegram'    => 'https://t.me/share/url?url={url}&text={text}',
				'viber'       => 'viber://forward?{url}={text}',
				'whatsapp'    => 'whatsapp://send?text={url}',
				'hacker_news' => 'https://news.ycombinator.com/submitlink?u={url}&t={text}',
				'vk'          => 'http://vk.com/share.php?url={url}&title={text}',
				'ok'          => 'https://connect.ok.ru/dk?st.cmd=WidgetSharePreview&st.shareUrl={url}',
				'flipboard'   => 'https://share.flipboard.com/bookmarklet/popout?v=2&title={text}&url={url}',
				'evernote'    => 'https://www.evernote.com/clip.action?url={url}&title={title}',
				'weibo'       => 'https://service.weibo.com/share/share.php?url=${url}',
				'xing'        => 'https://www.xing.com/app/user?op=share&url=${url}',
				'threema'     => 'threema://compose?text=&id={text}',
				'skype'       => 'https://web.skype.com/share?url=${url}',
				'line'        => 'https://line.me/R/msg/text/?${url}',
				'getpocket'   => 'https://getpocket.com/save?url=${url}&title=${title}',
			);

			if ( isset( $social_urls[ $args['social'] ] ) ) {
				$single_metadata['url'] = str_replace(
					'{url}',
					$home_url,
					str_replace(
						'{text}',
					 rishi__cb_customizer_encode_uri_component( get_the_title() ),
						$social_urls[ $args['social'] ]
					)
				);
			} else {
				$single_metadata['url'] = '#';
			}
		}

		return $single_metadata;
	}
}

if ( ! function_exists( 'rishi__cb_customizer_get_social_share_items' ) ) {
	function rishi__cb_customizer_get_social_share_items() {
		$prefix = rishi__cb_customizer_manager()->screen->get_prefix();

		return [
			[
				'id' => 'facebook',
				'enabled' => get_theme_mod(
					$prefix . '_share_facebook',
					'yes'
				) === 'yes',
			],

			[
				'id' => 'twitter',
				'enabled' => get_theme_mod(
					$prefix . '_share_twitter',
					'yes'
				) === 'yes',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_pinterest',
					'yes'
				) === 'yes',
				'id' => 'pinterest',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_linkedin',
					'yes'
				) === 'yes',
				'id' => 'linkedin',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_email',
					'no'
				) === 'yes',
				'id' => 'email',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_reddit',
					'no'
				) === 'yes',
				'id' => 'reddit',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_telegram',
					'no'
				) === 'yes',
				'id' => 'telegram',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_viber',
					'no'
				) === 'yes',
				'id' => 'viber',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_whatsapp',
					'no'
				) === 'yes',
				'id' => 'whatsapp',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_vk',
					'no'
				) === 'yes',
				'id' => 'vk',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_tumblr',
					'no'
				) === 'yes',
				'id' => 'tumblr',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_getpocket',
					'no'
				) === 'yes',
				'id' => 'getpocket',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_evernote',
					'no'
				) === 'yes',
				'id' => 'evernote',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_hacker_news',
					'no'
				) === 'yes',
				'id' => 'hacker_news',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_weibo',
					'no'
				) === 'yes',
				'id' => 'weibo',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_okru',
					'no'
				) === 'yes',
				'id' => 'okru',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_ok',
					'no'
				) === 'yes',
				'id' => 'ok',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_xing',
					'no'
				) === 'yes',
				'id' => 'xing',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_threema',
					'no'
				) === 'yes',
				'id' => 'threema',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_skype',
					'no'
				) === 'yes',
				'id' => 'skype',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_line',
					'no'
				) === 'yes',
				'id' => 'line',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_flipboard',
					'no'
				) === 'yes',
				'id' => 'flipboard',
			],

		];
	}
}

if ( ! function_exists( 'rishi__cb_customizer_get_social_box' ) ) {
	function rishi__cb_customizer_get_social_box( $args = array() ) {
		$args = wp_parse_args(
			$args,
			array(
				// url | share
				'type'                 => 'url',
				'socials'              => null,
				'attr'                 => array(),
				'class'                => '',
				'before_links_content' => '',

				'links_wrapper'        => null,
				'links_wrapper_attr'   => array(),

				'after_links_content'  => '',
				'has_count'            => false,
				'hide_labels'          => true,
				'root_class'           => 'cb__social-box',
				'force_output'         => false,
				'custom_share_url'     => '',
			)
		);

		if ( $args['type'] === 'share' ) {
			$args['socials'] = rishi__cb_customizer_get_social_share_items();
		}

		if ( $args['socials'] === null ) {
			$args['socials'] = array();

			foreach ( rishi__cb_customizer_get_social_networks_list() as $network_id => $network ) {
				$args['socials'][] = array(
					'id'      => $network_id,
					'enabled' => true,
				);
			}
		}

		$has_any_social = 0;

		foreach ( $args['socials'] as $single_social ) {
			if (
				! isset( $single_social['enabled'] )
				|| ( isset( $single_social['enabled'] )
					&&
					$single_social['enabled'] ) || $args['force_output']
			) {
				$has_any_social++;
			}
		}

		if ( ! $has_any_social ) {
			return '';
		}

		$old_attr = array();

		$old_attr['class'] = $args['root_class'];

		if ( ! empty( $args['class'] ) ) {
			$old_attr['class'] .= ' ' . $args['class'];
		}

		if ( $args['type'] === 'share' ) {
			// $old_attr['data-behavior'] = 'share';
		}

		if ( $args['has_count'] ) {
			$old_attr['data-count'] = $has_any_social;
		}

		$old_attr = array_merge( $old_attr, $args['attr'] );

		ob_start();

		?>

		<div <?php echo rishi__cb_customizer_attr_to_html( $old_attr ); ?>>
			<?php echo $args['before_links_content']; ?>

			<?php
			if ( $args['links_wrapper'] ) {
				$result = $args['links_wrapper'];

				$result = trim(
					$result . ' ' . rishi__cb_customizer_attr_to_html(
						$args['links_wrapper_attr']
					)
				);

				echo '<' . $result . '>';
			}
			?>

			<?php foreach ( $args['socials'] as $single_social ) { ?>
				<?php

				if ( ! $single_social['enabled'] && ! $args['force_output'] ) {
					continue;
				}

				$metadata = rishi__cb_customizer_get_social_metadata(
					array(
						'type'       => $args['type'],
						'social'     => $single_social['id'],
						'custom_url' => $args['custom_share_url'],
					)
				);

				if ( isset( $args['links_rel'] ) ) {
					$metadata['rel'] = $args['links_rel'];
				}

				$label_attr = array( 'class' => 'cb__label' );

				if ( $args['hide_labels'] ) {
					$label_attr['hidden'] = ' ';
				}
				?>

				<a href="<?php echo $metadata['url']; ?>" target="_blank" rel="<?php if( isset( $metadata['rel'] ) ) echo esc_attr( $metadata['rel'] ); ?>" data-network="<?php echo $single_social['id']; ?>" aria-label="<?php echo $metadata['name']; ?>">

					<span class="cb__icon-container">
						<?php echo $metadata['icon']; ?>
					</span>

					<span <?php echo rishi__cb_customizer_attr_to_html( $label_attr ); ?>><?php echo $metadata['name']; ?></span>
				</a>
			<?php } ?>

			<?php
			if ( $args['links_wrapper'] ) {
				echo '</' . $args['links_wrapper'] . '>';
			}
			?>

			<?php echo $args['after_links_content']; ?>
		</div>

		<?php

		return ob_get_clean();
	}
}

/**
 * Encore a string to be safely included in the URL.
 *
 * @param string $str String to encode for URL.
 */
if ( ! function_exists( 'rishi__cb_customizer_encode_uri_component' ) ) {
	function rishi__cb_customizer_encode_uri_component( $str ) {
		$revert = array(
			'%21' => '!',
			'%2A' => '*',
			'%27' => "'",
			'%28' => '(',
			'%29' => ')',
		);

		return strtr( rawurlencode( $str ), $revert );
	}
}

if ( ! function_exists( 'rishi__cb_customizer_get_social_networks_list' ) ) {
	function rishi__cb_customizer_get_social_networks_list() {
		$networks = array(
			'facebook'        => array(
				'label' => __( 'Facebook', 'rishi' ),
			),

			'twitter'         => array(
				'label' => __( 'Twitter', 'rishi' ),
			),

			'instagram'       => array(
				'label' => __( 'Instagram', 'rishi' ),
			),

			'pinterest'       => array(
				'label' => __( 'Pinterest', 'rishi' ),
			),

			'dribbble'        => array(
				'label' => __( 'Dribbble', 'rishi' ),
			),

			'behance'         => array(
				'label' => __( 'Behance', 'rishi' ),
			),

			'unsplash'        => array(
				'label' => __( 'Unsplash', 'rishi' ),
			),

			'five-hundred-px' => array(
				'label' => __( '500px', 'rishi' ),
			),

			'linkedin'        => array(
				'label' => __( 'LinkedIn', 'rishi' ),
			),

			'wordpress'       => array(
				'label' => __( 'WordPress', 'rishi' ),
			),

			'parler'          => array(
				'label' => __( 'Parler', 'rishi' ),
			),

			'medium'          => array(
				'label' => __( 'Medium', 'rishi' ),
			),

			'slack'           => array(
				'label' => __( 'Slack', 'rishi' ),
			),

			'codepen'         => array(
				'label' => __( 'CodePen', 'rishi' ),
			),

			'reddit'          => array(
				'label' => __( 'Reddit', 'rishi' ),
			),

			'twitch'          => array(
				'label' => __( 'Twitch', 'rishi' ),
			),

			'tiktok'          => array(
				'label' => __( 'TikTok', 'rishi' ),
			),

			'snapchat'        => array(
				'label' => __( 'Snapchat', 'rishi' ),
			),

			'spotify'         => array(
				'label' => __( 'Spotify', 'rishi' ),
			),

			'soundcloud'      => array(
				'label' => __( 'SoundCloud', 'rishi' ),
			),

			'apple_podcast'   => array(
				'label' => __( 'Apple Podcasts', 'rishi' ),
			),

			'patreon'         => array(
				'label' => __( 'Patreon', 'rishi' ),
			),

			'alignable'       => array(
				'label' => __( 'Alignable', 'rishi' ),
			),

			'skype'           => array(
				'label' => __( 'Skype', 'rishi' ),
			),

			'github'          => array(
				'label' => __( 'GitHub', 'rishi' ),
			),

			'gitlab'          => array(
				'label' => __( 'GitLab', 'rishi' ),
			),

			'youtube'         => array(
				'label' => __( 'YouTube', 'rishi' ),
			),

			'vimeo'           => array(
				'label' => __( 'Vimeo', 'rishi' ),
			),

			'dtube'           => array(
				'label' => __( 'DTube', 'rishi' ),
			),

			'facebook_group'  => array(
				'label' => __( 'Facebook Group', 'rishi' ),
			),

			'discord'         => array(
				'label' => __( 'Discord', 'rishi' ),
			),

			'tripadvisor'     => array(
				'label' => __( 'TripAdvisor', 'rishi' ),
			),

			'foursquare'      => array(
				'label' => __( 'Foursquare', 'rishi' ),
			),

			'yelp'            => array(
				'label' => __( 'Yelp', 'rishi' ),
			),

			'vk'              => array(
				'label' => __( 'VK', 'rishi' ),
			),

			'ok'              => array(
				'label' => __( 'Odnoklassniki', 'rishi' ),
			),

			'rss'             => array(
				'label' => __( 'RSS', 'rishi' ),
			),

			'xing'            => array(
				'label' => __( 'Xing', 'rishi' ),
			),

			'whatsapp'        => array(
				'label' => __( 'WhatsApp', 'rishi' ),
			),

			'viber'           => array(
				'label' => __( 'Viber', 'rishi' ),
			),

			'telegram'        => array(
				'label' => __( 'Telegram', 'rishi' ),
			),

			'weibo'           => array(
				'label' => __( 'Weibo', 'rishi' ),
			),

			'tumblr'          => array(
				'label' => __( 'Tumblr', 'rishi' ),
			),

			'qq'              => array(
				'label' => __( 'QQ', 'rishi' ),
			),

			'wechat'          => array(
				'label' => __( 'WeChat', 'rishi' ),
			),

			'strava'          => array(
				'label' => __( 'Strava', 'rishi' ),
			),

			'flickr'          => array(
				'label' => __( 'Flickr', 'rishi' ),
			),

			'phone'           => array(
				'label' => __( 'Phone', 'rishi' ),
			),

			'email'           => array(
				'label' => __( 'Email', 'rishi' ),
			),
		);

		$dynamic_networks = rishi__cb_customizer_get_dynamic_social_networks();

		foreach ( $dynamic_networks as $network ) {
			$networks[ $network['id'] ] = array(
				'label' => $network['name'],
			);
		}

		return $networks;
	}
}
